package com.bytesbee.mysinglelivechannel.activities;

import static com.bytesbee.mysinglelivechannel.utils.Constant.TRUE;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.api.ApiInterface;
import com.bytesbee.mysinglelivechannel.api.RestAdapter;
import com.bytesbee.mysinglelivechannel.callbacks.CallbackUser;
import com.bytesbee.mysinglelivechannel.managers.DialogManager;
import com.bytesbee.mysinglelivechannel.managers.Screens;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.utils.Constant;
import com.bytesbee.mysinglelivechannel.utils.Utils;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LoginActivity extends BaseAppActivity implements View.OnClickListener {

    private Call<CallbackUser> callbackCall = null;
    private EditText txtUsername;
    private EditText txtPassword;
    private String strUsername;
    private String strPassword;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login);

        setImmersionBarTheme();

        txtUsername = findViewById(R.id.txtUsername);
        txtPassword = findViewById(R.id.txtPassword);

        final TextView btnLogin = findViewById(R.id.btnLogin);
        final TextView btnRegistration = findViewById(R.id.btnRegistration);

        btnLogin.setOnClickListener(this);
        btnRegistration.setOnClickListener(this);

    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.btnLogin) {
            try {
                strUsername = txtUsername.getText().toString().trim();
                strPassword = txtPassword.getText().toString().trim();
                if (TextUtils.isEmpty(strUsername)) {
                    DialogManager.checkEmptyFields(getString(R.string.err_username_not_found), txtUsername);
                    return;
                } else if (TextUtils.isEmpty(strPassword)) {
                    DialogManager.checkEmptyFields(getString(R.string.err_password), txtPassword);
                    return;
                }
                callAPIRequest();
            } catch (Exception e) {
                Utils.getErrors(e);
            }
        } else if (v.getId() == R.id.btnRegistration) {
            startActivity(new Intent(mActivity, RegistrationActivity.class));
        }
    }

    /**
     * Call API request
     */
    private void callAPIRequest() {
        showWaitDialog();
        try {
            ApiInterface apiInterface = RestAdapter.createAPI(mActivity);
            callbackCall = apiInterface.login(Utils.getAPIKey(mActivity), strUsername, strPassword, Constant.DEVICE_TYPE);
            callbackCall.enqueue(new Callback<>() {
                @Override
                public void onResponse(@NonNull Call<CallbackUser> call, @NonNull Response<CallbackUser> response) {
                    hideWaitDialog();
                    final CallbackUser resp = response.body();
                    if (resp != null && resp.status.equals(Constant.SUCCESS)) {
                        SessionManager.get().setUserModel(resp.data);
                        SessionManager.get().setLogin(TRUE);
                        SessionManager.get().setOnOffNotification(TRUE);
                        Screens.showClearTopScreen(mActivity, MainActivity.class);
                    } else {
                        onFailRequest(resp != null ? resp.message : getString(R.string.err_failed_to_load));
                    }
                }

                @Override
                public void onFailure(@NonNull Call<CallbackUser> call, @NonNull Throwable t) {
                    hideWaitDialog();
                    Utils.sout(t.getMessage());
                    if (!call.isCanceled()) onFailRequest(getString(R.string.lblFailed));
                }
            });
        } catch (Exception e) {
            hideWaitDialog();
            Utils.getErrors(e);
        }
    }

    /**
     * Show response message which return from API call
     */
    private void onFailRequest(String strMessage) {
        try {
            if (Utils.isOnline(mActivity)) {
                DialogManager.showOKDialog(getString(R.string.lblLogin), strMessage);
            } else {
                DialogManager.showNoInternetDialog();
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    /**
     * Cancel call if its running
     */
    @Override
    public void onDestroy() {
        super.onDestroy();
        try {
            if (callbackCall != null && callbackCall.isExecuted()) {
                callbackCall.cancel();
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }
}
